program AVR_I2C_DAC;

Device = mega128, VCC=5;

Define_Fuses
  LockBits0 = [];
  FuseBits0 = [];
  FuseBits1 = [CKOPT, SPIEN, JTAGEN, OCDEN];
  FuseBits2 = [];
  ProgMode  = JTAG;

Import SysTick, TWImaster;

From System Import ;

Define
        ProcClock   = 16000000;        {Hertz}
        SysTick     = 10;             {msec}
        StackSize   = $0064, iData;
        FrameSize   = $0064, iData;
        TWIpresc    = TWI_BR400;

Implementation

{$IDATA}

{--------------------------------------------------------------}
{ Type Declarations }

type


{--------------------------------------------------------------}
{ Const Declarations }
const
  PCF9555          : byte = $21;
  DAC1_PortRD      : byte = 0;
  DAC1_PortWR      : byte = 2;
  DAC1_PortDDR     : byte = 6;
  DAC2_PortRD      : byte = 1;
  DAC2_PortWR      : byte = 3;
  DAC2_PortDDR     : byte = 7;


{--------------------------------------------------------------}
{ Var Declarations }
{$IDATA}
var
  bb         : byte;


{--------------------------------------------------------------}
{ functions }



{--------------------------------------------------------------}
{ Main Program }
{$IDATA}

begin
  EnableInts;
  TWIout(PCF9555, DAC1_PortDDR, $00);        // all output
  TWIout(PCF9555, DAC2_PortDDR, $00);        // all output
  loop
    TWIout(PCF9555, DAC1_PortWR, bb);        // saw tooth
    TWIout(PCF9555, DAC2_PortWR, (not bb));        // saw tooth
    inc(bb);
  endloop;
end AVR_I2C_DAC.

