(*************************************************************)
(* This is a test program example which shows how to build   *)
(* a stand alone FAT16 MMC drive with the AVRco and a mega64 *)
(* The PC counter part EXE "MMCtest.exe" is included in the  *)
(* AVRco Demos directory in the "M64_MMC" folder             *)
(* Complete assembled and tested hardware can be ordered in  *)
(* the E-LAB internet shop                                   *)
(*************************************************************)

program MMC_M64;

Device = mega64, VCC = 3.3;

Define_Fuses
  LockBits0      = [];
  FuseBits0      = [BODEN];
  FuseBits1      = [CKOPT, SPIEN, JTAGEN, OCDEN];
  FuseBits2      = [];
  ProgMode       = JTAG;

Import SysTick, SerPort, FAT16;

From System Import LongWord, LongInt, Float;

Define
  ProcClock      = 16000000;        {Hertz}
  SysTick        = 10;              {msec}
  StackSize      = $0050, iData;
  FrameSize      = $0100, iData;
  SerPort        = 57600, Stop2{, TimeOut};
  RxBuffer       = 100, iData;
  TxBuffer       = 100, iData;
  FAT16          = MMC_SPI, iData;
  F16_FileHandles = 2;
  F16_DirLevels  = 2;

uses UFAT16;

Implementation

{$IDATA}

{--------------------------------------------------------------}
{ Type Declarations }

type
  tFileCmd    = (cmdSync, cmdGetState, cmdSetBaud, cmdRestart, cmdDiskFree,
                 cmdDiskSize, cmdFileAttr, cmdEraseAll, cmdCreateDir, cmdEraseDir,
                 cmdChangeDir, cmdPathExist, cmdCurDir, cmdFileExist, cmdFileSize,
                 cmdFileRename, cmdFileCopy, cmdFileDelete, cmdListFiles,
                 cmdFileAssign, cmdFileOpen, cmdCheckHandle, cmdFilePos, cmdFileSeek,
                 cmdBlockRead, cmdBlockWrite, cmdFileClose, cmdFileCreate,
                 cmdRandWrite, cmdEndOfFile, cmdFileSizeH, cmdRawAccess);

  tDiskState  = (dsNoDisk, dsWriteProt, dsDiskErr, dsDiskOk);

  tMediaState = (msUnKnown, msDiskChanged, msInit);

{--------------------------------------------------------------}
{ Const Declarations }
{$IDATA}
const
  ACK       : char  = #6;
  LF        : char  = #10;
  CR        : char  = #13;
  NAK       : char  = #21;
  ESC       : char  = #27;

{--------------------------------------------------------------}
{ Var Declarations }
{$PDATA}
var
  CardProt[@PinD, 2]   : bit;
  NoCard[@PinD, 3]     : bit;

{$IDATA}
var
  DiskState      : tDiskState;
  MediaState     : tMediaState;
  DiskError      : tDiskError;
  FileCmd        : tFileCmd;
  FPath, FPath1  : TPathStr;
  FName, FName1  : TFileName;
  fAttr          : tFAttr;
  fTime, fDate   : Word;
  SR             : TSearchRec;
  Fh             : File;
  HandleOk       : boolean;
  FileMode       : TFileAccess;
{$NOOVRCHECK}
  Fhw[@Fh]       : word;
  ww             : word;
  lw             : longword;
  CommErr        : byte;
  RxTxBuff       : array[0..511] of byte;


{--------------------------------------------------------------}
{ functions }
procedure PortInit;
begin
  DDRA:= $00;                            // all input
  PortA:= $FF;                           // all pullups on
  DDRB:= DDRB or $01;                    // MMC select as output
  PortB:= $FF;                           // all pullups on
  DDRC:= $00;                            // all input
  PortC:= $FF;                           // all pullups on
  DDRD:= DDRD and %00000011;             // change all bits to input except TWI bits
  PortD:= $FF;                           // all pullups on
  DDRE:= $00;                            // all input
  PortE:= $FF;                           // all pullups on
  DDRF:= $00;                            // all input
  PortF:= $FF;                           // all pullups on
  DDRG:= $00;                            // all input
  PortG:= $FF;                           // all pullups on
end;

function RxHexByte : byte;
var
  st     : string[2];
  b      : byte;
begin
  Read(SerInp, st, 2);
  b:= HexToInt(st);
  if RunErr then
    inc(CommErr);
  endif;
  ClearRunErr;
  return(b);
end;

function RxHexWord : word;
var
  st     : string[4];
  w      : word;
begin
  Read(SerInp, st, 4);
  w:= HexToInt(st);
  if RunErr then
    inc(CommErr);
  endif;
  ClearRunErr;
  return(w);
end;

function RxHexInt : integer;
var
  st     : string[4];
  i      : integer;
begin
  Read(SerInp, st, 4);
  i:= HexToInt(st);
  if RunErr then
    inc(CommErr);
  endif;
  ClearRunErr;
  return(i);
end;

function RxHexLw : longword;
var
  st     : string[8];
  lw     : longword;
begin
  Read(SerInp, st, 8);
  lw:= HexToInt(st);
  if RunErr then
    inc(CommErr);
  endif;
  ClearRunErr;
  return(lw);
end;

function RxHexLI : longint;
var
  st     : string[8];
  li     : longint;
begin
  Read(SerInp, st, 8);
  li:= HexToInt(st);
  if RunErr then
    inc(CommErr);
  endif;
  ClearRunErr;
  return(li);
end;

procedure RxFilePath;
begin
  Read(SerInp, fPath, #0);
  ClearRunErr;
end;

procedure RxFileName;
begin
  Read(SerInp, FName, #0);
  ClearRunErr;
end;

function RxFileHandle : boolean;
begin
  Fhw:= RxHexWord;
  FileMode:= F16_CheckHandle(Fh);
  if FileMode = faNone then
    HandleOk:= false;
    return(false);
  else
    HandleOk:= true;
    return(true);
  endif;
end;

procedure RxFileAttr;
begin
  fAttr:= tFAttr(RxHexByte);
end;

procedure RxFileTime;
begin
  fTime:= RxHexWord;
end;

procedure RxFileDate;
begin
  fDate:= RxHexWord;
end;

procedure RxBlock(count : word);
var
  pt      : pointer;
begin
  pt:= @RxTxBuff;
  while count > 0 do
    pt^++:= SerInp;
    dec(count);
  endwhile;
end;

procedure TxBlock(count : word);
var
  pt      : pointer;
begin
  pt:= @RxTxBuff;
  while count > 0 do
    SerOut(pt^++);
    dec(count);
  endwhile;
end;

function SetBaudRate(br : word) : boolean;
var
  ok    : boolean;
begin
  ok:= true;
  case br of
    0       : case (PinD and $60) of
                0   : br:= 9600;
                    |
                $20 : br:= 19200;
                    |
                $40 : br:= 38400;
                    |
                $60 : br:= 57600;
                    |
              endcase;
            |
    9600    :
            |
    19200   :
            |
    38400   :
            |
    57600   :
            |
  else
    ok:= false;
  endcase;
  if ok then
    SerOut(ACK);
    mDelay(100);
    SerBaud(br);
    mDelay(100);
    FlushBuffer(RxBuffer);
  else
    SerOut(NAK);
  endif;
  return(ok);
end;

Function RestartFileSys : boolean;
begin
// DiskState  = (dsNoDisk, dsWriteProt, dsDiskErr, dsDiskOk);
// MediaState = (msUnKnown, msDiskChanged, msInit);
  if not NoCard then
    return(false);
  endif;
  DiskState:= dsDiskErr;
  if not F16_DiskInit then
    return(false);
  endif;
  if not F16_DiskReset then
    return(false);
  endif;
  if not CardProt then                 // 0 = protected
    DiskState:= dsWriteProt;
  else
    DiskState:= dsDiskOk;
  endif;
  MediaState:= msInit;
  return(true);
end;


{--------------------------------------------------------------}
{ Main Program }
{$IDATA}

begin
  PortInit;
  EnableInts;
  mDelay(100);
  SetBaudRate(0);

  loop
    FileCmd:= tFileCmd(SerInp);
    if FileCmd <> cmdGetState then
      // clear previous errors
      CommErr:= 0;
    endif;

    case FileCmd of
      cmdSync       : // do nothing
                      F16_GetDiskError;
                      DiskError:= deNone;
                    |
      cmdGetState   : // return comm, drive and file states
                      DiskError:= F16_GetDiskError;
                      write(SerOut, cmdGetState + DiskState + MediaState + DiskError + CommErr + F16_GetUsedHandles);
                      CommErr:= 0;
                    |
      cmdSetBaud    : // set baudrate
                      SerOut(cmdSetBaud);
                      ww:= RxHexWord;
                      if CommErr <> 0 then
                        SerOut(NAK);
                      else
                        SetBaudRate(ww);
                      endif;
                    |
      cmdRestart    : // Restart FileSys
                      SerOut(cmdRestart);
                      if RestartFileSys then
                        SerOut(ACK);
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdDiskFree   : // Send DiskFree
                      SerOut(cmdDiskFree);
                      if MediaState = msInit then
                        SerOut(ACK);
                        Write(SerOut, LongToHex(F16_GetDiskFree));
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdDiskSize   : // SendDiskSize
                      SerOut(cmdDiskSize);
                      if MediaState = msInit then
                        SerOut(ACK);
                        Write(SerOut, LongToHex(F16_GetDiskSize));
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileAttr   : // read or write a file attribute
                      SerOut(cmdFileAttr);
                      case SerInp of
                        'G' : // Get File attribute
                              SerOut('G');
                              RxFilePath;
                              RxFileName;
                              if (MediaState = msInit) and (CommErr = 0) then
                                if F16_FileGetAttr(fPath, FName, fAttr) then
                                  SerOut(ACK);
                                  Write(SerOut, ByteToHex(fAttr));
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                        'S' : // Set File attribute
                              SerOut('S');
                              RxFilePath;
                              RxFileName;
                              RxFileAttr;
                              if (MediaState = msInit) and (CommErr = 0) then
                                if DiskState  = dsWriteProt then
                                  SerOut(NAK);
                                elsif F16_FileSetAttr(fPath, FName, fAttr) then
                                  SerOut(ACK);
                                  Write(SerOut, ByteToHex(fAttr));
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                      else
                        SerOut('?');
                      endcase;
                    |
      cmdEraseAll   : // Remove all files
                      SerOut(cmdEraseAll);
                      if MediaState = msInit then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_DiskFormat then
                          F16_DiskReset;
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdCreateDir  : // create a new directory
                      SerOut(cmdCreateDir);
                      RxFilePath;
                      RxFileName;
                      RxFileTime;
                      RxFileDate;
                      if (MediaState = msInit) and (CommErr = 0) then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_CreateDir(fPath, FName, fTime, fDate) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdEraseDir   : // delete a directory
                      SerOut(cmdEraseDir);
                      RxFilePath;
                      RxFileName;
                      if MediaState = msInit then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_RemoveDir(fPath, FName) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdChangeDir  : // change the default directory
                      SerOut(cmdChangeDir);
                      RxFilePath;
                      if MediaState = msInit then
                        if F16_ChangeDir(fPath) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdPathExist  : // check a path
                      SerOut(cmdPathExist);
                      RxFilePath;
                      if MediaState = msInit then
                        if F16_PathExist(fPath) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdCurDir     : // get the current directory
                      SerOut(cmdCurDir);
                      if MediaState = msInit then
                        fPath:= F16_GetCurDir;
                        SerOut(ACK);
                        Write(SerOut, fPath+#0);
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileExist  : // check a file existance
                      SerOut(cmdFileExist);
                      RxFilePath;
                      RxFileName;
                      RxFileAttr;
                      if (MediaState = msInit) and (CommErr = 0) then
                        if F16_FileExist(fPath, fName, fAttr) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileSize   : // return the byte count of a file
                      SerOut(cmdFileSize);
                      RxFilePath;
                      RxFileName;
                      if MediaState = msInit then
                        if F16_FileSize(fPath, fName, lw) then
                          SerOut(ACK);
                          Write(SerOut, LongToHex(lw));
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileRename : // rename a file
                      SerOut(cmdFileRename);
                      RxFilePath;
                      RxFileName;
                      FName1:= FName;
                      RxFileName;
                      if MediaState = msInit then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_FileRename(fPath, FName1, FName) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileCopy   : // copy a file
                      SerOut(cmdFileCopy);
                      RxFilePath;
                      FPath1:= FPath;
                      RxFileName;
                      FName1:= FName;
                      RxFilePath;
                      RxFileName;
                      if MediaState = msInit then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_FileCopy(FPath1, FName1, FPath, FName) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileDelete : // delete a file
                      SerOut(cmdFileDelete);
                      RxFilePath;
                      RxFileName;
                      if MediaState = msInit then
                        if DiskState  = dsWriteProt then
                          SerOut(NAK);
                        elsif F16_FileDelete(fPath, fName) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdListFiles  : // list files
                      SerOut(cmdListFiles);
                      RxFilePath;
                      RxFileName;
                      RxFileAttr;
                      if (MediaState = msInit) and (CommErr = 0) then
                        if F16_FindFirst(fPath, fName, fAttr, sr) then
                          SerOut(ACK);
                          Write(SerOut, sr.Name + #0);
                          Write(SerOut, ByteToHex(sr.Dir.FAttr));
                          while SerInp = CR do
                            if F16_FindNext(sr) then
                              SerOut(ACK);
                              Write(SerOut, sr.Name + #0);
                              Write(SerOut, ByteToHex(sr.Dir.FAttr));
                            else
                              break;
                            endif;
                          endwhile;
                          SerOut(NAK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileAssign : // assign a file and get the handle
                      SerOut(cmdFileAssign);
                      RxFilePath;
                      RxFileName;
                      if MediaState = msInit then
                        if F16_FileAssign(fh, fPath, fName) then
                          SerOut(ACK);
                          Write(SerOut, IntToHex(word(fh)));
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdCheckHandle: // check a handle
                      SerOut(cmdCheckHandle);
                      RxFileHandle;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        SerOut(ACK);
                        SerOut(FileMode);
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileOpen   : // open a file for read or write access
                      SerOut(cmdFileOpen);
                      case SerInp of
                        'R' : // open a file for reading
                              SerOut('R');
                              RxFileHandle;
                              if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                                if F16_FileReset(fh) then
                                  SerOut(ACK);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                        'W' : // open a file for writing
                              SerOut('W');
                              RxFileHandle;
                              RxFileAttr;
                              RxFileTime;
                              RxFileDate;
                              if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                                if DiskState  = dsWriteProt then
                                  SerOut(NAK);
                                elsif F16_FileRewrite(fh, fAttr, fTime, fDate) then
                                  SerOut(ACK);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                        'A' : //  open a file for write appends
                              SerOut('A');
                              RxFileHandle;
                              if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                                if DiskState  = dsWriteProt then
                                  SerOut(NAK);
                                elsif F16_FileAppend(fh) then
                                  SerOut(ACK);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                        'M' : //  open a file for random writing
                              SerOut('M');
                              RxFileHandle;
                              if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                                if DiskState  = dsWriteProt then
                                  SerOut(NAK);
                                elsif F16_RandomWrite(fh) then
                                  SerOut(ACK);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                      else
                        SerOut('?');
                      endcase;
                    |
      cmdFilePos    : // get the current pointer into a file
                      SerOut(cmdFilePos);
                      RxFileHandle;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        lw:= F16_FilePos(fh);
                        Write(SerOut, ACK + LongToHex(lw));
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileSeek   : // set the file pointer to a position
                      SerOut(cmdFileSeek);
                      RxFileHandle;
                      lw:= RxHexLw;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        lw:= F16_FileSeek(fh, lw);
                        Write(SerOut, ACK + LongToHex(lw));
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdBlockRead  : // read a block of data out of a file
                      SerOut(cmdBlockRead);
                      RxFileHandle;
                      ww:= RxHexWord;
                      if (ww = 0) or (ww > $200) then
                        SerOut(NAK);
                      else
                        if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                          if F16_BlockRead(fh, @RxTxBuff, ww, ww) then
                            Write(SerOut, ACK + IntToHex(ww));
                            TxBlock(ww);
                          else
                            SerOut(NAK);
                          endif;
                        else
                          SerOut(NAK);
                        endif;
                      endif;
                    |
      cmdBlockWrite : // write a block of data into a file
                      SerOut(cmdBlockWrite);
                      RxFileHandle;
                      ww:= RxHexWord;
                      if (ww = 0) or (ww > $200) then
                        SerOut(NAK);
                      else
                        RxBlock(ww);
                        if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                          if F16_BlockWrite(fh, @RxTxBuff, ww, ww) then
                            Write(SerOut, ACK + IntToHex(ww));
                          else
                            SerOut(NAK);
                          endif;
                        else
                          SerOut(NAK);
                        endif;
                      endif;
                    |
      cmdFileClose  : // close a file
                      SerOut(cmdFileClose);
                      RxFileHandle;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        F16_FileClose(fh);
                        SerOut(ACK);
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileCreate : // create a new file and preset its size
                      SerOut(cmdFileCreate);
                      RxFilePath;
                      RxFileName;
                      RxFileAttr;
                      RxFileTime;
                      RxFileDate;
                      lw:= RxHexLW;
                      if (MediaState = msInit) and (CommErr = 0) then
                        if F16_FileCreate(fPath, fName, fAttr, fTime, fDate, lw) then
                          SerOut(ACK);
                        else
                          SerOut(NAK);
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdRandWrite  : // random write a block of data into a file
                      SerOut(cmdRandWrite);
                      RxFileHandle;
                      ww:= RxHexWord;
                      if (ww = 0) or (ww > $200) then
                        SerOut(NAK);
                      else
                        RxBlock(ww);
                        if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                          if F16_BlockRandomWrite(fh, @RxTxBuff, ww, ww) then
                            Write(SerOut, ACK + IntToHex(ww));
                          else
                            SerOut(NAK);
                          endif;
                        else
                          SerOut(NAK);
                        endif;
                      endif;
                    |
      cmdEndOfFile  : // request for file pointer = end of the file
                      SerOut(cmdEndOfFile);
                      RxFileHandle;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        if F16_EndOfFile(fh) then
                          SerOut(byte(true));
                        else
                          SerOut(byte(false));
                        endif;
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdFileSizeH  : // get the byte count of an open file
                      SerOut(cmdFileSizeH);
                      RxFileHandle;
                      if HandleOk and (MediaState = msInit) and (CommErr = 0) then
                        lw:= F16_FileSizeH(fh);
                        Write(SerOut, ACK + LongToHex(lw));
                      else
                        SerOut(NAK);
                      endif;
                    |
      cmdRawAccess  : //
                      SerOut(cmdRawAccess);
                      case SerInp of
                        'R' : // read a physical sector
                              if DiskState = dsNoDisk then
                                SerOut(NAK);
                              elsif not F16_DiskInit then
                                SerOut(NAK);
                              else
                                SerOut(ACK);
                              endif;
                              lw:= RxHexLw;
                              if CommErr = 0 then
                                _BootOffs:= 0;
                                if F16_ReadSector(lw, @RxTxBuff) then
                                  SerOut(ACK);
                                  TxBlock(512);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                        'W' : // write a physical sector
                              if DiskState in[dsNoDisk, dsWriteProt] then
                                SerOut(NAK);
                              elsif not F16_DiskInit then
                                SerOut(NAK);
                              else
                                SerOut(ACK);
                              endif;
                              lw:= RxHexLw;
                              if CommErr = 0 then
                                SerOut(ACK);
                                RxBlock(512);
                                _BootOffs:= 0;
                                if F16_WriteSector(lw, @RxTxBuff) then
                                  SerOut(ACK);
                                else
                                  SerOut(NAK);
                                endif;
                              else
                                SerOut(NAK);
                              endif;
                            |
                      else
                        SerOut('?');
                      endcase;
                    |
    else
      SerOut('?');
    endcase;
    // house keepings
    if not NoCard then                      // 0 = no card
      DiskState:= dsNoDisk;
      MediaState:= msUnKnown;
    elsif DiskState = dsNoDisk then        // new card inserted
      if not CardProt then                 // 0 = protected
        DiskState:= dsWriteProt;
      else
        DiskState:= dsDiskOk;
      endif;
      MediaState:= msDiskChanged;
    endif;
//    DiskState  = (dsNoDisk, dsWriteProt, dsDiskErr, dsDiskOk);
//    MediaState = (msUnKnown, msDiskChanged, msInit);
  endloop;
end MMC_M64.


