unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComPortsN, Thales, Tasten, FileCtrl, JvDriveCtrls, StdCtrls,
  JvCtrls, ExtCtrls, ComCtrls, JvTreeView2, Thalmisc, Buttons, Menus, DlgFName,
  ImgList, AppEvnts;

  
const
  DirLevels   = 2;


type
  // FAT16 system types
  tFAttrEnum  = (faReadOnly, faHidden, faSysFile, faVolumeID, faDirectory, faArchive);
  tFAttr      = Set of tFAttrEnum;

  tDiskError  = (deNone, deMediaUnknown, deFATunknown, deInitFail, deHandleFail,
                 deReadFail, deWriteFail, deReadOnly, deFileExists, deNotFound);

  TFileAccess = (faNone, faAssign, faRead, faWrite, faAppend, faRandomWr);

  TFileName   = string[12];
  TPathStr    = String[3 + (DIRlevels * 9)];

  // Interface comm types
  tFileCmd    = (cmdSync, cmdGetState, cmdSetBaud, cmdRestart, cmdDiskFree,
                 cmdDiskSize, cmdFileAttr, cmdEraseAll, cmdCreateDir, cmdEraseDir,
                 cmdChangeDir, cmdPathExist, cmdCurDir, cmdFileExist, cmdFileSize,
                 cmdFileRename, cmdFileCopy, cmdFileDelete, cmdListFiles,
                 cmdFileAssign, cmdFileOpen, cmdCheckHandle, cmdFilePos, cmdFileSeek,
                 cmdBlockRead, cmdBlockWrite, cmdFileClose, cmdFileCreate,
                 cmdRandWrite, cmdEndOfFile, cmdFileSizeH, cmdRawAccess);

  tDiskState  = (dsNoDisk, dsWriteProt, dsDiskErr, dsDiskOk);

  tMediaState = (msUnKnown, msDiskChanged, msInit);


const
  faFilesOnly : tFAttr = [faReadOnly, faHidden, faSysFile, faArchive];
  faAnyFile   : tFAttr = [faReadOnly, faHidden, faSysFile, faVolumeID, faDirectory, faArchive];


type
  TMMCtst = class(TForm)
    ComPort: TComPortN;
    Panel1: TPanel;
    BaudSpin: TTextSpin;
    JvDriveList: TJvDriveList;
    JvDirectoryListBox: TJvDirectoryListBox;
    JvFileListBox: TJvFileListBox;
    IniEditor: TIniEditor;
    COMportSpin: TTextSpin;
    DisconnectBtn: TSpeedButton;
    ConnectBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    DiskStateLab: TLabel;
    MediaStateLab: TLabel;
    DiskErrorLab: TLabel;
    CommErrLab: TLabel;
    HandlesLab: TLabel;
    InitBtn: TSpeedButton;
    label6: TLabel;
    DiskSizeLab: TLabel;
    Label7: TLabel;
    DiskFreeLab: TLabel;
    TreeView: TTreeView;
    Label8: TLabel;
    Label9: TLabel;
    FileDelBtn: TBitBtn;
    FileRenameBtn: TBitBtn;
    RefreshBtn: TSpeedButton;
    SyncBtn: TSpeedButton;
    NewDirBtn: TBitBtn;
    ImageList: TImageList;
    FileCreateBtn: TBitBtn;
    CloseBtn: TBitBtn;
    FileInfoBtn: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    BootUpBtn: TBitBtn;
    BootDownBtn: TBitBtn;
    HintCheck: TCheckBox;
    FormatBtn: TBitBtn;
    ProgressBar: TProgressBar;
    Label10: TLabel;
    Label11: TLabel;
    StatusBar: TStatusBar;
    ApplicationEvents1: TApplicationEvents;
    procedure FormCreate(Sender: TObject);
    procedure JvFileListBoxClick(Sender: TObject);
    procedure JvDriveListChange(Sender: TObject);
    procedure JvDirectoryListBoxChange(Sender: TObject);
    procedure JvDirectoryListBoxClick(Sender: TObject);
    procedure DisconnectBtnClick(Sender: TObject);
    procedure ConnectBtnClick(Sender: TObject);
    procedure COMportSpinChanged(Sender: TObject);
    procedure BaudSpinChanged(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure InitBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure TreeViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure JvFileListBoxDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure JvFileListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure SyncBtnClick(Sender: TObject);
    procedure NewDirBtnClick(Sender: TObject);
    procedure FileDelBtnClick(Sender: TObject);
    procedure FileRenameBtnClick(Sender: TObject);
    procedure TreeViewClick(Sender: TObject);
    procedure FileCreateBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FileInfoBtnClick(Sender: TObject);
    procedure BootUpBtnClick(Sender: TObject);
    procedure BootDownBtnClick(Sender: TObject);
    procedure FormatBtnClick(Sender: TObject);
    procedure JvFileListBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ApplicationEvents1ShowHint(var HintStr: String;
      var CanShow: Boolean; var HintInfo: THintInfo);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    ComName   : string;
    BaudRate  : word;
    ComOk     : boolean;
    TimeOut   : boolean;

    DiskState  : tDiskState;
    MediaState : tMediaState;
    DiskError  : tDiskError;
    CommErrors : byte;
    UsedHandles: byte;

    function  OpenPort : boolean;
    procedure ClosePort;
    function  RecvChar(var ch : char) : boolean;
    function  RecvCharTO(var ch : char; time : word) : boolean;
    function  SendChar(ch : char)  : boolean;
    procedure SendStr(st : string; zero : boolean);
    function  RecvStr(var st : string) : boolean;
    procedure SetDTR(onOff : boolean);
    procedure SetRTS(onOff : boolean);
    function  ReceiveStat : boolean;
    procedure FlushComRx;
    procedure FlushComTx;

    procedure CommErr;
    function  SendCmd(chk : tFileCmd) : boolean;
    function  ReceiveAck : boolean;
    function  GetStatus : boolean;
    function  RxHexByte(var b : byte) : boolean;
    function  RxHexWord(var w : Word) : boolean;
    function  RxHexLong(var L : dWord) : boolean;
    procedure TxHexByte(b : byte);
    procedure TxHexWord(w : word);
    procedure TxHexLong(L : dword);
    procedure TxFileName(st : string);
    function  RequestFATdata : boolean;
    function  RequestFileList : boolean;
    procedure SetFileOpButtons;
  end;

var
  MMCtst  : TMMCtst;

implementation

{$R *.dfm}

const
  ACK       = #6;
  LF        = #10;
  CR        = #13;
  NAK       = #21;
  ESC       = #27;

  maxBoot   = 255;

  DiskStateArr  : array[tDiskState] of string =
                       ('NoDisk', 'WriteProtect', 'DiskError', 'DiskOk');

  MediaStateArr : array[tMediaState] of string =
                       ('UnKnown', 'DiskChanged', 'DiskInit');

  DiskErrorArr  : array[tDiskError] of string  =
                       ('noError', 'MediaUnknown', 'FATunknown', 'InitFail',
                        'HandleFail', 'ReadFail', 'WriteFail', 'ReadOnly',
                        'FileExists', 'NotFound');

type
  tFNArec = record
              fName : string;
              fAttr : tFAttr;
            end;

var
  root     : TTreeNode;
  RootList : array[0..40] of tFNArec;
  SubList  : array[0..40] of tFNArec;
  BootBlock: packed array[0..maxBoot, 0..511] of byte;


procedure TMMCtst.FormCreate(Sender: TObject);
begin
  JvDriveList.Drive:= 'C';
  ComName:= IniEditor.ReadStr('COM', 'COMport', 'COM1');
  BaudRate:= IniEditor.ReadInt('COM', 'BaudRate', 57600);
  HintCheck.Checked:= IniEditor.ReadBool('General', 'Hints', true);
  COMportSpin.PosString:= ComName;
  BaudSpin.PosInteger:= BaudRate;
  ComPort.CustomBaudRate:= BaudRate;
  ComPort.Port:= ComName;
end;

procedure TMMCtst.ApplicationEvents1ShowHint(var HintStr: String;
  var CanShow: Boolean; var HintInfo: THintInfo);
begin
  CanShow:= HintCheck.Checked;
  StatusBar.Panels[0].Text:= HintStr;
end;

procedure TMMCtst.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  IniEditor.WriteStr('COM', 'COMport', ComName);
  IniEditor.WriteInt('COM', 'BaudRate', BaudRate);
  IniEditor.WriteBool('General', 'Hints', HintCheck.Checked);
end;

function TMMCtst.OpenPort : boolean;
begin
  ComPort.connected:= false;
  ComPort.Port:= ComName;
  try
    ComPort.Open;
    result:= ComPort.connected;
  except
    result:= false;
  end;
end;

function TMMCtst.ReceiveStat : boolean;
begin
  result:= ComPort.InputCount <> 0;
end;

procedure TMMCtst.SetDTR(onOff : boolean);
begin
  ComPort.SetDTR(onOff);
end;

procedure TMMCtst.SetRTS(onOff : boolean);
begin
  ComPort.SetRTS(onOff);
end;

procedure TMMCtst.ClosePort;
begin
  ComPort.Close;
  ComOk:= false;
end;

function TMMCtst.RecvChar(var ch : char) : boolean;
begin
  result:= false;
  try
    result:= ComPort.Read(ch, 1) = 1;
  except
    result:= false;
  end;
end;

function TMMCtst.RecvCharTO(var ch : char; time : word) : boolean;
var CurTicks : DWord;
begin
  Result:= false;
  CurTicks:= GetTickCount;
  repeat
    result:= RecvChar(ch);
    timeOut:= (GetTickCount - CurTicks) > time;
    if not result then Application.ProcessMessages;
  until TimeOut or Result;
end;

function TMMCtst.SendChar(ch : char) : boolean;
var idx   : integer;
begin
  result:= false;
  if ComPort.Write(ch, 1) <> 1 then begin
    repeat
      Application.ProcessMessages;
    until ComPort.Write(ch, 1) = 1;
  end;
end;

procedure TMMCtst.SendStr(st : string; zero : boolean);
var idx   : integer;
begin
  if length(st) > 0 then begin
    for idx:= 1 to length(st) do begin
      SendChar(st[idx]);
      Application.ProcessMessages;
    end;
  end;
  if zero then SendChar(#0);
end;

procedure TMMCtst.TxFileName(st : string);
var
  fn, ext   : string;
begin
  fn:= ChangeFileExt(st, '');
  ext:= ExtractFileExt(st);
  if length(fn) > 8 then setlength(fn, 8);
  if length(ext) > 4 then setlength(ext, 4);
  st:= fn+ext;
  SendStr(st, true);
end;

function TMMCtst.RecvStr(var st : string) : boolean;
var ch      : char;
begin
  st:= '';
  while RecvCharTO(ch, 2000) do begin
    if ch <> #0 then st:= st + ch
    else break;
  end;
  result:= not Timeout;
end;

procedure TMMCtst.FlushComRx;
begin
  ComPort.ClearBuffer(true, false);
end;

procedure TMMCtst.FlushComTx;
begin
  ComPort.ClearBuffer(false, true);
end;

procedure TMMCtst.JvFileListBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then begin
    JvFileListBox.Update;
  end;
end;

procedure TMMCtst.JvDriveListChange(Sender: TObject);
begin
  try
    JvDirectoryListBox.Drive:= JvDriveList.Drive;
  except
    JvDriveList.Drive:= JvDirectoryListBox.Drive;
  end;
end;

procedure TMMCtst.JvDirectoryListBoxClick(Sender: TObject);
begin
  JvDirectoryListBox.Update;
end;

procedure TMMCtst.JvDirectoryListBoxChange(Sender: TObject);
begin
  JvFileListBox.Directory:= JvDirectoryListBox.Directory;
end;

procedure TMMCtst.JvFileListBoxClick(Sender: TObject);
begin
//
end;

procedure TMMCtst.TreeViewClick(Sender: TObject);
begin
  SetFileOpButtons;
end;

procedure TMMCtst.COMportSpinChanged(Sender: TObject);
begin
  ComName:= COMportSpin.PosString;
  ComPort.Port:= ComName;
end;

procedure TMMCtst.BaudSpinChanged(Sender: TObject);
begin
  BaudRate:= BaudSpin.PosInteger;
  ComPort.CustomBaudRate:= BaudRate;
end;

procedure TMMCtst.SetFileOpButtons;
var
  isDir      : boolean;
  isFile     : boolean;
begin
//    DiskState  : tDiskState;
//    DiskError  : tDiskError;
//    CommErrors : byte;
  if MediaState = msInit then begin
    BootUpBtn.Enabled:= true;
    BootDownBtn.Enabled:= true;
    FormatBtn.Enabled:= TreeView.Items.Count > 1;
    RefreshBtn.enabled:= true;
    if (TreeView.Selected <> nil) then begin
      if TreeView.Selected.ImageIndex = 0 then begin        // real file selected
        FileCreateBtn.Enabled:= false;
        FileDelBtn.Enabled:= true;
        FileInfoBtn.Enabled:= true;
        FileRenameBtn.Enabled:= true;
        NewDirBtn.Enabled:= false;
      end
      else if TreeView.Selected.ImageIndex = 2 then begin    // root directory
        FileCreateBtn.Enabled:= true;
        FileDelBtn.Enabled:= false;
        FileInfoBtn.Enabled:= false;
        FileRenameBtn.Enabled:= false;
        NewDirBtn.Enabled:= true;
      end
      else begin                                             // directory selected
        NewDirBtn.Enabled:= false;
        FileDelBtn.Enabled:= false;
        FileInfoBtn.Enabled:= false;
        FileRenameBtn.Enabled:= false;
        FileCreateBtn.Enabled:= true;
      end;
    end
    else begin
      FileCreateBtn.Enabled:= false;
      FileInfoBtn.Enabled:= false;
      FileDelBtn.Enabled:= false;
      FileRenameBtn.Enabled:= false;
      NewDirBtn.Enabled:= false;
    end;
  end
  else begin
    if DiskError = deFATunknown then begin
      BootUpBtn.Enabled:= true;
      BootDownBtn.Enabled:= true;
    end
    else begin
      BootUpBtn.Enabled:= false;
      BootDownBtn.Enabled:= false;
    end;
    RefreshBtn.enabled:= false;
    FileCreateBtn.Enabled:= false;
    FileDelBtn.Enabled:= false;
    FileInfoBtn.Enabled:= false;
    FileRenameBtn.Enabled:= false;
    FormatBtn.Enabled:= false;
    NewDirBtn.Enabled:= false;
  end;
end;

procedure TMMCtst.DisconnectBtnClick(Sender: TObject);
begin
  if not COMok then exit;
  TreeView.Items.Clear;
  COMok:= false;
  COMportSpin.enabled:= true;
  BaudSpin.enabled:= true;
  InitBtn.enabled:= false;
  RefreshBtn.enabled:= false;
  SyncBtn.Enabled:= false;
  BootUpBtn.Enabled:= false;
  BootDownBtn.Enabled:= false;
  FormatBtn.Enabled:= false;
  FileCreateBtn.Enabled:= false;
  FileDelBtn.Enabled:= false;
  FileInfoBtn.Enabled:= false;
  FileRenameBtn.Enabled:= false;
  NewDirBtn.Enabled:= false;
  DiskStateLab.Caption:= '???';
  MediaStateLab.Caption:= '???';
  DiskErrorLab.Caption:= '???';
  CommErrLab.Caption:= '???';
  HandlesLab.Caption:= '???';
  DiskSizeLab.Caption:= '???';
  DiskFreeLab.Caption:= '???';
  StatusBar.Panels[1].Text:= DiskErrorLab.Caption;
  ClosePort;
end;

procedure TMMCtst.ConnectBtnClick(Sender: TObject);
var
  ch : char;
begin
  if COMok then exit;
  TreeView.Items.Clear;
  COMportSpin.enabled:= false;
  BaudSpin.enabled:= false;
  if OpenPort then begin
    SendChar('?');
    if RecvCharTO(ch, 2000) then begin
      COMok:= ch = '?';
      if COMok then begin
        SendChar(char(cmdSync));                // clear all file errors
        COMok:= GetStatus;
      end;
    end;
  end;
  if COMok then begin
//    InitBtn.enabled:= true;
    if MediaState = msInit then begin
      if RequestFATdata then begin
        RequestFileList;
        SetFileOpButtons;
      end;
    end;
    SyncBtn.Enabled:= true;
  end
  else begin
    DisconnectBtn.Down:= true;
    COMportSpin.enabled:= true;
    BaudSpin.enabled:= true;
    InitBtn.enabled:= false;
    RefreshBtn.enabled:= false;
    SyncBtn.Enabled:= false;
    BootUpBtn.Enabled:= false;
    FormatBtn.Enabled:= false;
    BootDownBtn.Enabled:= false;
    FileCreateBtn.Enabled:= false;
    FileDelBtn.Enabled:= false;
    FileInfoBtn.Enabled:= false;
    FileRenameBtn.Enabled:= false;
    NewDirBtn.Enabled:= false;
    DiskStateLab.Caption:= '???';
    MediaStateLab.Caption:= '???';
    DiskErrorLab.Caption:= '???';
    CommErrLab.Caption:= '???';
    HandlesLab.Caption:= '???';
    DiskSizeLab.Caption:= '???';
    DiskFreeLab.Caption:= '???';
    StatusBar.Panels[1].Text:= DiskErrorLab.Caption;
  end;
end;

procedure TMMCtst.SyncBtnClick(Sender: TObject);
var
  idx       : integer;
begin
  if COMok then begin
    FlushComRx;
    for idx:= 0 to 127 do begin
      SendChar(#0);
    end;
    FlushComRx;
    GetStatus;
    SetFileOpButtons;
  end;
end;

procedure TMMCtst.InitBtnClick(Sender: TObject);
begin
  TreeView.Items.Clear;
  RefreshBtn.enabled:= false;
  FileCreateBtn.Enabled:= false;
  FileDelBtn.Enabled:= false;
  FileInfoBtn.Enabled:= false;
  FileRenameBtn.Enabled:= false;
  FormatBtn.Enabled:= false;
  NewDirBtn.Enabled:= false;
  FlushComRx;
  if SendCmd(cmdRestart) then begin
    if ReceiveAck then begin
      if RequestFATdata then begin
        RequestFileList;
      end;
    end;
    SendChar(char(cmdSync));
    GetStatus;
  end;
  SetFileOpButtons;
end;

procedure TMMCtst.RefreshBtnClick(Sender: TObject);
begin
  FlushComRx;
  RequestFileList;
end;

procedure TMMCtst.CommErr;
begin
  Screen.Cursor:= crDefault;
  Beep;
  GetStatus;
  // a future release must show more error infos :-)
  MessageDlg('Communication Error !', mtError, [mbAbort], 0);
end;

function TMMCtst.SendCmd(chk : tFileCmd) : boolean;
var ch     : char;
begin
  SendChar(char(chk));
  result:= false;
  if RecvCharTO(ch, 2000) then begin
    result:= ch = char(chk);
  end;
end;

function TMMCtst.ReceiveAck : boolean;
var ch     : char;
begin
  result:= false;
  if RecvCharTO(ch, 2000) then begin
    result:= ch = ACK;
  end;
end;

function TMMCtst.GetStatus : boolean;
var
  ch         : char;
begin
  result:= false;
  DiskState:= dsDiskErr;
  MediaState:= msUnKnown;
  InitBtn.enabled:= false;
  RefreshBtn.enabled:= false;
  FileCreateBtn.Enabled:= false;
  FileDelBtn.Enabled:= false;
  FileInfoBtn.Enabled:= false;
  FormatBtn.Enabled:= false;
  FileRenameBtn.Enabled:= false;
  NewDirBtn.Enabled:= false;
  FlushComRx;
  SendChar(char(cmdGetState));
  // receive 6 bytes
  if RecvCharTO(ch, 2000) then begin
    if ch <> char(cmdGetState) then begin
      DiskStateLab.Caption:= '???';
      MediaStateLab.Caption:= '???';
      DiskErrorLab.Caption:= '???';
      CommErrLab.Caption:= '???';
      HandlesLab.Caption:= '???';
      StatusBar.Panels[1].Text:= DiskErrorLab.Caption;
      exit;
    end;
  end
  else begin
    exit;
  end;
  if RecvCharTO(ch, 2000) then begin
    DiskState:= tDiskState(ch);
    DiskStateLab.Caption:= DiskStateArr[DiskState];
  end
  else begin
    DiskStateLab.Caption:= '???';
    exit;
  end;
  if RecvCharTO(ch, 2000) then begin
    MediaState:= tMediaState(ch);
    MediaStateLab.Caption:= MediaStateArr[MediaState];
  end
  else begin
    MediaStateLab.Caption:= '???';
    exit;
  end;
  if RecvCharTO(ch, 2000) then begin
    DiskError:= tDiskError(ch);
    DiskErrorLab.Caption:= DiskErrorArr[DiskError];
    StatusBar.Panels[1].Text:= DiskErrorLab.Caption;
  end
  else begin
    DiskErrorLab.Caption:= '???';
    StatusBar.Panels[1].Text:= DiskErrorLab.Caption;
    exit;
  end;
  if RecvCharTO(ch, 2000) then begin
    CommErrors:= byte(ch);
    CommErrLab.Caption:= IntToStr(CommErrors);
  end
  else begin
    CommErrLab.Caption:= '???';
    exit;
  end;
  if RecvCharTO(ch, 2000) then begin
    UsedHandles:= byte(ch);
    HandlesLab.Caption:= IntToStr(UsedHandles);
  end
  else begin
    HandlesLab.Caption:= '???';
    exit;
  end;
  InitBtn.enabled:= MediaState in [msDiskChanged, msInit];
  SetFileOpButtons;
  result:= true;
end;

function TMMCtst.RxHexByte(var b : byte) : boolean;
var
  st        : string;
  idx       : integer;
  ch        : char;
begin
  result:= true;
  st:= '$';
  for idx:= 1 to 2 do begin
    if RecvCharTO(ch, 2000) then begin
      st:= st+ch;
    end
    else begin
      result:= false;
      break;
    end;
  end;
  if result then begin
    try
      b:= StrToInt(st);
    except
      result:= false;
    end;
  end;
end;

function TMMCtst.RxHexWord(var w : Word) : boolean;
var
  st        : string;
  idx       : integer;
  ch        : char;
begin
  result:= true;
  st:= '$';
  for idx:= 1 to 4 do begin
    if RecvCharTO(ch, 2000) then begin
      st:= st+ch;
    end
    else begin
      result:= false;
      break;
    end;
  end;
  if result then begin
    try
      w:= StrToInt(st);
    except
      result:= false;
    end;
  end;
end;

function TMMCtst.RxHexLong(var L : dWord) : boolean;
var
  st        : string;
  idx       : integer;
  ch        : char;
begin
  result:= true;
  st:= '$';
  for idx:= 1 to 8 do begin
    if RecvCharTO(ch, 6000) then begin
      st:= st+ch;
    end
    else begin
      result:= false;
      break;
    end;
  end;
  if result then begin
    try
      L:= StrToInt(st);
    except
      result:= false;
    end;
  end;
end;

procedure TMMCtst.TxHexByte(b : byte);
var st     : string;
begin
  st:= IntToHex(b, 2);
  SendStr(st, false);
end;

procedure TMMCtst.TxHexWord(w : word);
var st     : string;
begin
  st:= IntToHex(w, 4);
  SendStr(st, false);
end;

procedure TMMCtst.TxHexLong(L : dword);
var st     : string;
begin
  st:= IntToHex(L, 8);
  SendStr(st, false);
end;

function TMMCtst.RequestFATdata : boolean;
var
  ch        : char;
  st        : string;
  v         : dword;
begin
  result:= true;
  Screen.Cursor:= crHourglass;
  if SendCmd(cmdDiskFree) then begin
    if ReceiveAck then begin
      if RxHexLong(v) then begin
        DiskFreeLab.Caption:= IntToStr(v div 1000000)+'MB';
      end;
    end
    else result:= false;
  end
  else result:= false;
  if SendCmd(cmdDiskSize) then begin
    if ReceiveAck then begin
      if RxHexLong(v) then begin
        DiskSizeLab.Caption:= IntToStr(v div 1000000)+'MB';
      end;
    end
    else result:= false;
  end
  else result:= false;
  if not result then begin
    DiskSizeLab.Caption:= '???';
    DiskFreeLab.Caption:= '???';
    FlushComRx;
  end;
  Screen.Cursor:= crDefault;
  Beep;
end;

function TMMCtst.RequestFileList : boolean;
var
  ch      : char;
  st      : string;
  rCount,
  sCount,
  y, z    : integer;
  node,
  subNode : TTreeNode;

  function ReadFiles(dir : string; sub : boolean) : integer;
  var
    a       : tFAttr;
    b       : byte;
    idx     : integer;
  begin
    idx:= 0;
    if SendCmd(cmdListFiles) then begin
      SendStr(dir, true);             // FilePath = root
      SendStr('*.*', true);           // FileName = all
      TxHexByte(byte(faAnyFile));     // FileAttr = files and dirs
      while ReceiveAck do begin
        if RecvStr(st) then begin
          if RxHexByte(b) then begin
            a:= tFAttr(b);
          end
          else begin
            a:= [];
          end;
          if sub then begin
            subList[idx].fName:= st;
            subList[idx].fAttr:= a;
          end
          else begin
            RootList[idx].fName:= st;
            RootList[idx].fAttr:= a;
          end;
          inc(idx);
          if idx <= 40 then begin
            SendChar(CR);
          end
          else begin
            SendChar(char(cmdSync));
          end;
        end
        else begin
          SendChar(char(cmdSync));
          break;
        end;
      end;
    end;
    result:= idx;
  end;

begin
  Screen.Cursor:= crHourglass;
  rCount:= ReadFiles('\', false);
  FlushComRx;
  TreeView.Items.Clear;
  root:= TreeView.Items.AddNode(nil, nil, 'MMC-Root', nil, naAdd);
  root.ImageIndex:= 2;
  root.SelectedIndex:= 2;
  if rCount > 0 then begin
    // at first build the directories
    for y:= 0 to rCount-1 do begin
      if faDirectory in RootList[y].fAttr then begin
        node:= TreeView.Items.AddChild(root, RootList[y].fName);
        node.ImageIndex:= 1;
        node.SelectedIndex:= 1;
        node.Data:= pointer(1);
        sCount:= ReadFiles(RootList[y].fName, true);
        for z:= 0 to sCount-1 do begin
          subNode:= TreeView.Items.AddChild(node, SubList[z].fName);
          if faDirectory in SubList[z].fAttr then begin
            TreeView.Items.AddChild(subNode, '');
          end;
        end;
      end;
    end;
    // now register the root files
    for y:= 0 to rCount-1 do begin
      if not (faDirectory in RootList[y].fAttr) then begin
        node:= TreeView.Items.AddChild(root, RootList[y].fName);
      end;
    end;
  end;
  SendChar(char(cmdSync));        // clear file errors
  TreeView.FullExpand;
  Screen.Cursor:= crDefault;
  SetFileOpButtons;
end;

// File Drag and Drops
procedure TMMCtst.TreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if Source is TTreeView then begin
    Accept:= false;
  end
  else if MediaState <> msInit then begin
    Accept:= false;
  end
  else begin
    if (TreeView.GetNodeAt(X, Y) = nil) then begin
      Accept:= false;
    end
    else if TreeView.GetNodeAt(X, Y).ImageIndex in[1, 2] then begin
      Accept:= true;
    end
    else begin
      Accept:= false;
    end;
  end;
end;

procedure TMMCtst.TreeViewDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  node       : TTreeNode;
  ch         : char;
  fn,
  srcFName,
  dir, fname : string;
  srcFh      : file;
  dstFH      : word;
  Buf        : array[0..511] of byte;
  res        : dword;
  idx, idy   : integer;
  w          : word;
begin
  if TreeView.GetNodeAt(X, Y).ImageIndex = 2 then begin
    // root
    dir:= '\';
  end
  else begin
    // subdir
    node:= TreeView.GetNodeAt(X, Y);
    dir:= '\'+node.Text;
  end;
  srcFName:= JvFileListBox.Filename;
  if srcFName = '' then exit;
  fName:= ExtractFileName(srcFName);
  if FName = '' then exit;
  FName:= ExtractShortPathName(FName);
  // Copy File from PC to MMC
  // check for dest exist
  if SendCmd(cmdFileExist) then begin
    SendStr(dir, true);             // FilePath = root
    TxFileName(fName);              // FileName = dropped
    TxHexByte(byte(faAnyFile));     // FileAttr = files and dirs
    if ReceiveAck then begin
      Beep;
      if MessageDlg('File MMC:'+FName+' already exists!'+#13+#10+'Overwrite?',
                    mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;
    end
    else begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
    end;
  end
  else begin
    exit;
  end;
  // open dest file
  Screen.Cursor:= crHourglass;
  if SendCmd(cmdFileAssign) then begin
    SendStr(dir, true);             // FilePath = root
    TxFileName(fName);              // FileName = dropped
    if ReceiveAck then begin
      if not RxHexWord(dstFH) then begin
        CommErr;
        exit;
      end;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
  // open dest file for writing
  if SendCmd(cmdFileOpen) then begin
    SendChar('W');
    if not RecvCharTO(ch, 2000) then begin        // ch = 'W'
      CommErr;
      exit;
    end;
    TxHexWord(dstFH);                             // File Handle
    TxHexByte(0);                                 // File Attr = none
    TxHexWord(0);                                 // File Time = dummy
    TxHexWord(0);                                 // File Date = dummy
    if not ReceiveAck then begin
      CommErr;
      exit;
    end;
  end;

  // now open source for read
  AssignFile(srcFh, srcFName);
  try
    Reset(srcFh, 1);
  except
    SendCmd(cmdFileClose);
    TxHexWord(dstFH);                             // File Handle
    ReceiveAck;
    Screen.Cursor:= crDefault;
    MessageDlg('Disk Read Acces to'+#13+#10+'"'+FName+'" failed !', mtError, [mbCancel], 0);
    RefreshBtnClick(Sender);
    exit;
  end;
  idy:= FileSize(srcFh) div 512;
  ProgressBar.Position:= 0;
  ProgressBar.Max:= idy;
  idy:= 0;
  repeat
    BlockRead(srcFh, Buf, 512, res);
    if res > 0 then begin
      if SendCmd(cmdBlockWrite) then begin
        TxHexWord(dstFH);                             // File Handle
        TxHexWord(res);                               // block size
        for idx:= 0 to res -1 do begin
          SendChar(char(buf[idx]));
        end;
        if ReceiveAck then begin
          RxHexWord(w);
          if w <> res then begin
            CommErr;
            SendCmd(cmdFileClose);
            TxHexWord(dstFH);                             // File Handle
            ReceiveAck;
            CloseFile(srcFh);
            res:= 0;
            exit;
          end;
          inc(idy);
          ProgressBar.Position:= idy;
        end
        else begin
          CommErr;
          SendCmd(cmdFileClose);
          TxHexWord(dstFH);                             // File Handle
          ReceiveAck;
          CloseFile(srcFh);
          res:= 0;
          exit;
        end;
      end
      else begin
        CommErr;
        SendCmd(cmdFileClose);
        TxHexWord(dstFH);                             // File Handle
        ReceiveAck;
        CloseFile(srcFh);
        res:= 0;
        exit;
      end;
    end;
  until res = 0;

  SendCmd(cmdFileClose);
  TxHexWord(dstFH);                             // File Handle
  ReceiveAck;
  CloseFile(srcFh);
  Beep;
  GetStatus;
  RequestFileList;
  Screen.Cursor:= crDefault;
  ProgressBar.Position:= 0;
end;

procedure TMMCtst.JvFileListBoxDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  if Source is TTreeView then begin
    if (TreeView.Selected <> nil) and (TreeView.Selected.ImageIndex = 0) then begin
      Accept:= true;
    end
    else begin
      Accept:= false;
    end;
  end
  else begin
    Accept:= false;
  end;
end;

procedure TMMCtst.JvFileListBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  node       : TTreeNode;
  ch         : char;
  srcFName,
  dir, fname : string;
  dstFH      : file;
  srcFh      : word;
  Buf        : array[0..511] of byte;
  res        : dword;
  idx, idy   : integer;
  w          : word;
begin
  srcFName:= TreeView.selected.Text;
  if TreeView.selected.Parent = root then begin
    // root
    dir:= '\';
  end
  else begin
    // file is in subdir
    node:= TreeView.Selected.Parent;
    dir:= '\'+node.Text;
  end;
  FName:= JvFileListBox.Directory+'\'+srcFName;
  if srcFName = '' then exit;
  if FName = '' then exit;
  // Copy File from MMC to PC
  // check for dest exist
  if FileExists(FName) then begin
      Beep;
      if MessageDlg('File MMC:'+FName+' already exists!'+#13+#10+'Overwrite?',
                    mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;
  end;
  // open source file
  Screen.Cursor:= crHourglass;
  if SendCmd(cmdFileAssign) then begin
    SendStr(dir, true);                // FilePath
    TxFileName(srcFName);              // FileName
    if ReceiveAck then begin
      if not RxHexWord(srcFH) then begin
        CommErr;
        exit;
      end;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
  // open source file for read
  if SendCmd(cmdFileOpen) then begin
    SendChar('R');
    if not RecvCharTO(ch, 2000) then begin        // ch = 'R'
      CommErr;
      exit;
    end;
    TxHexWord(srcFH);                             // File Handle
    if not ReceiveAck then begin
      CommErr;
      exit;
    end;
  end;

  if SendCmd(cmdFileSizeH) then begin
    TxHexWord(srcFH);                             // File Handle
    if ReceiveAck then begin
      RxHexLong(res);
      idy:= res div 512;
    end;
  end;
  ProgressBar.Position:= 0;
  ProgressBar.Max:= idy;
  // now open dest for write
  AssignFile(dstFh, FName);
  Rewrite(dstFh, 1);
  if idy > 0 then begin
    // source file not empty
    idy:= 0;
    repeat
      if SendCmd(cmdBlockRead) then begin
        TxHexWord(srcFH);                             // File Handle
        TxHexWord(512);                               // block size
        if ReceiveAck then begin
          RxHexWord(w);
          for idx:= 0 to w -1 do begin
            if RecvCharTO(ch, 2000) then begin
              buf[idx]:= byte(ch);
            end
            else begin
              CommErr;
              SendCmd(cmdFileClose);
              TxHexWord(srcFH);                             // File Handle
              ReceiveAck;
              CloseFile(dstFh);
              exit;
            end;
          end;
          if w > 0 then BlockWrite(dstFh, Buf, w, res);
          // last block read?
          if w < 512 then w:= 0;
          inc(idy);
          ProgressBar.Position:= idy;
        end
        else begin
          CommErr;
          SendCmd(cmdFileClose);
          TxHexWord(srcFH);                             // File Handle
          ReceiveAck;
          CloseFile(dstFh);
          exit;
        end;
      end
      else begin
        CommErr;
        SendCmd(cmdFileClose);
        TxHexWord(srcFH);                             // File Handle
        ReceiveAck;
        CloseFile(dstFh);
        exit;
      end;
    until w = 0;
  end;

  SendCmd(cmdFileClose);
  TxHexWord(srcFH);                             // File Handle
  ReceiveAck;
  CloseFile(dstFh);
  Screen.Cursor:= crDefault;
  JvFileListBox.Update;
  ProgressBar.Position:= 0;
  Beep;
end;

procedure TMMCtst.NewDirBtnClick(Sender: TObject);
var
  node       : TTreeNode;
  ext,
  srcFName,
  dir, fname : string;
begin
  // root
  dir:= '\';

  FileNameDlg.NameEdit.Text:= '';
  FileNameDlg.DotLabel.visible:= false;
  FileNameDlg.ExtLabel.visible:= false;
  FileNameDlg.ExtEdit.Visible:= false;
  FileNameDlg.Caption:= 'Dir Name';
  if FileNameDlg.ShowModal <> mrOk then begin
    beep;
    exit;
  end;
  FName:= FileNameDlg.NameEdit.Text;
  if FileNameDlg.NameEdit.Text = '' then begin
    beep;
    exit;
  end;

  if SendCmd(cmdCreateDir) then begin
    SendStr(dir, true);                           // FilePath
    TxFileName(FName);                            // new Dir
    TxHexWord(0);                                 // File Time = dummy
    TxHexWord(0);                                 // File Date = dummy
    if ReceiveAck then begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      RequestFileList;
      Beep;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
end;

procedure TMMCtst.FileDelBtnClick(Sender: TObject);
var
  node       : TTreeNode;
  ch         : char;
  srcFName,
  dir, fname : string;
begin
  srcFName:= TreeView.selected.Text;
  if TreeView.selected.Parent = root then begin
    // root
    dir:= '\';
  end
  else begin
    // file is in subdir
    node:= TreeView.Selected.Parent;
    dir:= '\'+node.Text;
  end;
  if not (MessageDlg('Really want to delete'+#13+#10+'file "'+srcFName+'" ?',
                      mtConfirmation, [mbYes,mbNo], 0) = mrYes) then begin
    exit;
  end;
  if SendCmd(cmdFileDelete) then begin
    SendStr(dir, true);                // FilePath
    TxFileName(srcFName);              // FileName
    if ReceiveAck then begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      RequestFileList;
      Beep;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
end;

procedure TMMCtst.FileRenameBtnClick(Sender: TObject);
var
  node       : TTreeNode;
  ext,
  srcFName,
  dir, fname : string;
begin
  srcFName:= TreeView.selected.Text;
  if TreeView.selected.Parent = root then begin
    // root
    dir:= '\';
  end
  else begin
    // file is in subdir
    node:= TreeView.Selected.Parent;
    dir:= '\'+node.Text;
  end;

  FName:= ChangeFileExt(srcFName, '');;
  FileNameDlg.NameEdit.Text:= FName;
  ext:= ExtractFileExt(srcFName);
  if ext <> '' then begin
    delete(ext, 1, 1);
  end;
  FileNameDlg.ExtEdit.Text:= ext;
  FileNameDlg.DotLabel.visible:= true;
  FileNameDlg.ExtLabel.visible:= true;
  FileNameDlg.ExtEdit.Visible:= true;
  FileNameDlg.Caption:= 'Rename File to...';
  if FileNameDlg.ShowModal <> mrOk then begin
    beep;
    exit;
  end;
  FName:= FileNameDlg.NameEdit.Text;
  if FileNameDlg.ExtEdit.Text <> '' then begin
    FName:= FName+'.'+FileNameDlg.ExtEdit.Text;
  end;

  if SendCmd(cmdFileRename) then begin
    SendStr(dir, true);                // FilePath
    TxFileName(srcFName);              // old FileName
    TxFileName(FName);                 // new FileName
    if ReceiveAck then begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      RequestFileList;
      Beep;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
end;

procedure TMMCtst.FileCreateBtnClick(Sender: TObject);
var
  node       : TTreeNode;
  ext,
  srcFName,
  dir, fname : string;
begin
  if TreeView.selected.ImageIndex = 2 then begin
    // root
    dir:= '\';
  end
  else begin
    // file is in subdir
    dir:= '\'+TreeView.Selected.Text;
  end;

  FileNameDlg.NameEdit.Text:= '';
  FileNameDlg.ExtEdit.Text:= '';
  FileNameDlg.DotLabel.visible:= true;
  FileNameDlg.ExtLabel.visible:= true;
  FileNameDlg.ExtEdit.Visible:= true;
  FileNameDlg.Caption:= 'File Name';
  if FileNameDlg.ShowModal <> mrOk then begin
    beep;
    exit;
  end;
  FName:= FileNameDlg.NameEdit.Text;
  if FileNameDlg.ExtEdit.Text = '' then begin
    beep;
    exit;
  end
  else begin
    FName:= FName+'.'+FileNameDlg.ExtEdit.Text;
  end;

  if SendCmd(cmdFileCreate) then begin
    SendStr(dir, true);                           // FilePath
    TxFileName(FName);                            // new File
    TxHexByte(0);                                 // File Attr = none
    TxHexWord(0);                                 // File Time = dummy
    TxHexWord(0);                                 // File Date = dummy
    TxHexLong(0);                                 // set file length to zero
    if ReceiveAck then begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      RequestFileList;
      Beep;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
end;

procedure TMMCtst.CloseBtnClick(Sender: TObject);
begin
  close;
end;

procedure TMMCtst.FileInfoBtnClick(Sender: TObject);
var
  node       : TTreeNode;
  ch         : char;
  srcFName,
  dir, fname : string;
  fCount     : dWord;
begin
  srcFName:= TreeView.selected.Text;
  if TreeView.selected.Parent = root then begin
    // root
    dir:= '\';
  end
  else begin
    // file is in subdir
    node:= TreeView.Selected.Parent;
    dir:= '\'+node.Text;
  end;
  if SendCmd(cmdFileSize) then begin
    SendStr(dir, true);                // FilePath
    TxFileName(srcFName);              // FileName
    if ReceiveAck then begin
      RxHexLong(fCount);
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      Beep;
      MessageDlg('File Size of "'+srcFName+'" is'+#13+#10+IntToStr(fCount div 1024)+' kBytes', mtInformation, [mbOK], 0);
    end
    else begin
      CommErr;
      exit;
    end;
  end;
end;

procedure TMMCtst.FormatBtnClick(Sender: TObject);
begin
  if SendCmd(cmdEraseAll) then begin
    if ReceiveAck then begin
      GetStatus;
      if (DiskState = dsNoDisk) or (DiskState = dsDiskErr) or (MediaState <> msInit) then begin
        CommErr;
        exit;
      end;
      Beep;
    end
    else begin
      CommErr;
      exit;
    end;
  end;
  DisconnectBtn.Down:= true;
  DisconnectBtnClick(Sender);
end;

procedure TMMCtst.BootUpBtnClick(Sender: TObject);
var
  ch        : char;
  idx, x    : integer;
  err       : boolean;
  Fname, st : string;
  fh        : file;
begin
  FillChar(BootBlock, sizeOf(BootBlock), 0);
  err:= false;
  Screen.Cursor:= crHourglass;
  ProgressBar.Max:= maxBoot;
  ProgressBar.Position:= 0;
  InitBtn.enabled:= false;
  RefreshBtn.enabled:= false;
  SyncBtn.Enabled:= false;
  BootUpBtn.Enabled:= false;
  BootDownBtn.Enabled:= false;
  FormatBtn.Enabled:= false;
  FileCreateBtn.Enabled:= false;
  FileDelBtn.Enabled:= false;
  FileInfoBtn.Enabled:= false;
  FileRenameBtn.Enabled:= false;
  NewDirBtn.Enabled:= false;
  for idx:= 0 to maxBoot do begin
    if SendCmd(cmdRawAccess) then begin
      SendChar('R');
      if ReceiveAck then begin
        TxHexLong(idx);
        if not ReceiveAck then begin
          CommErr;
          err:= true;
          break;
        end;
        for x:= 0 to 511 do begin
          if RecvCharTo(ch, 1000) then begin
            BootBlock[idx, x]:= byte(ch);
          end
          else begin
            CommErr;
            err:= true;
            break;
          end;
        end;
        GetStatus;
        if (DiskState = dsNoDisk) then begin
          CommErr;
          err:= true;
          break;
        end;
        if err then break;
      end
      else begin
        CommErr;
        err:= true;
        break;
      end;
    end;
    if err then break;
    ProgressBar.Position:= idx;
  end;
  Screen.Cursor:= crDefault;
  BEEP;

  DisconnectBtn.Down:= true;
  DisconnectBtnClick(Sender);
  ProgressBar.Position:= 0;
  if not err then begin
    if SaveDialog.Execute then begin
      Fname:= SaveDialog.Filename;
      if FileExists(FName) then begin
        st:= ExtractFileName(FName);
        if not (MessageDlg('File "'+st+'" exists!'+#13+#10+'Overwrite it?',
                mtWarning, [mbYes,mbNo], 0) = mrYes) then begin
          exit;
        end;
      end;
      AssignFile(fh, FName);
      rewrite(fh, 1);
      BlockWrite(fh, BootBlock, sizeOf(BootBlock));
      CloseFile(fh);
    end;
  end;
end;

procedure TMMCtst.BootDownBtnClick(Sender: TObject);
var
  ch        : char;
  idx, x    : integer;
  err       : boolean;
  Fname, st : string;
  fh        : file;
begin
  FillChar(BootBlock, sizeOf(BootBlock), 0);
  if OpenDialog.Execute then begin
    Fname:= OpenDialog.Filename;
    AssignFile(fh, FName);
    reset(fh, 1);
    if FileSize(fh) <> sizeOf(BootBlock) then begin
      beep;
      MessageDlg('File Size mismatch !', mtError, [mbCancel], 0);
      CloseFile(fh);
      exit;
    end;
    BlockRead(fh, BootBlock, sizeOf(BootBlock), idx);
    CloseFile(fh);
  end;

  if MessageDlg('Attention! Bootfile must be compatible to the Card size!'
                +#13+#10+'Continue?', mtWarning, [mbYes,mbNo], 0) <> mrYes then begin
    exit;
  end;
  
  err:= false;
  Screen.Cursor:= crHourglass;
  ProgressBar.Max:= maxBoot;
  ProgressBar.Position:= 0;
  InitBtn.enabled:= false;
  RefreshBtn.enabled:= false;
  SyncBtn.Enabled:= false;
  BootUpBtn.Enabled:= false;
  BootDownBtn.Enabled:= false;
  FormatBtn.Enabled:= false;
  FileCreateBtn.Enabled:= false;
  FileDelBtn.Enabled:= false;
  FileInfoBtn.Enabled:= false;
  FileRenameBtn.Enabled:= false;
  NewDirBtn.Enabled:= false;

  for idx:= 0 to maxBoot do begin
    if SendCmd(cmdRawAccess) then begin
      SendChar('W');
      if ReceiveAck then begin
        TxHexLong(idx);
        if not ReceiveAck then begin
          CommErr;
          err:= true;
          break;
        end;
        for x:= 0 to 511 do begin
          ch:= char(BootBlock[idx, x]);
          SendChar(ch);
        end;
        if not ReceiveAck then begin
          CommErr;
          err:= true;
          break;
        end;
        if err then break;
      end
      else begin
        CommErr;
        err:= true;
        break;
      end;
    end
    else begin
      CommErr;
      err:= true;
    end;
    if err then break;
    ProgressBar.Position:= idx;
  end;
  Screen.Cursor:= crDefault;
  BEEP;

  DisconnectBtn.Down:= true;
  DisconnectBtnClick(Sender);
  ProgressBar.Position:= 0;
end;

end.

SerOut(cmdRawAccess);
case SerInp of
'R' : // read a physical sector
      if DiskState = dsNoDisk then
        SerOut(NAK);
      elsif not F16_DiskInit then
        SerOut(NAK);
      else
        SerOut(ACK);
      endif;
      lw:= RxHexLw;
      if CommErr = 0 then
        if F16_ReadSector(lw, @RxTxBuff) then
          SerOut(ACK);
          TxBlock(512);
        else
          SerOut(NAK);
        endif;
      else
        SerOut(NAK);
      endif;
    |
'W' : // write a physical sector
      if DiskState in[dsNoDisk, dsWriteProt] then
        SerOut(NAK);
      elsif not F16_DiskInit then
        SerOut(NAK);
      else
        SerOut(ACK);
      endif;
      lw:= RxHexLw;
      if CommErr = 0 then
        SerOut(ACK);
        RxBlock(512);
        if F16_WriteSector(lw, @RxTxBuff) then
          SerOut(ACK);
        else
          SerOut(NAK);
        endif;
      else
        SerOut(NAK);
      endif;
    |

